%store the results for all simulations
res_all = zeros(10, 1);

%m denotes the number of agents and n denotes the number of items
m = 20; n = 6;

%valuation; V(i, j) denotes the value of the ith item to the jth agent
V = [[1.05, 14.61, 0.05, 5.09, 0, 6.7, 5.01, 1.91, 9.21, 0.05, 0, 1.06, 0.05, 0.2, 3.5, 13.05, 0, 0, 3.02, 0.05], 
[1.93, 17.45, 0.1, 5.42, 0, 5, 2.2, 2.91, 0, 0.05, 0.57, 1.5, 0.05, 0, 0.29, 2, 0, 10, 4.99, 0.05], 
[0, 24.64, 0.05, 15.4, 26.03, 26.08, 4.49, 4.05, 11.58, 0.05, 0.57, 3.1, 0.05, 0.2, 0.85, 2, 0.05, 7, 4.03, 0.05], 
[0, 27.95, 0.2, 12.36, 2.01, 0.9, 8.68, 4.32, 10.27, 0.05, 0.57, 1.37, 0.05, 0.2, 1.67, 5.05, 0.5, 6.1, 2.04, 0.05], 
[0.56, 4.41, 0.1, 5.83, 4.85, 0, 2.49, 4.37, 0, 4, 0.77, 1.65, 2, 0.2, 4.41, 8, 0.95, 0, 2.05, 2], 
[1.25, 21.71, 8, 13.21, 10.52, 10, 7.23, 5.04, 11.1, 0.05, 0.57, 3.2, 0.05, 0.2, 0.05, 3, 10.51, 10, 5.15, 0]];

%we do ten simulations in total, with seeds from 1 to 10
for seed = 1 : 10
    rng(seed);
    %set random budget constraint
    budget = rand(m, 1) * 10;
    %all-one vectors of length n and m, respectively
    onesn = ones(n, 1);
    onesm = ones(m, 1);
    %ultimate result; initiate with 1
    res = 1;

    %iterate through all pairs of agents
    %ind1 = i1, ind2 = i2 => i1^th and i2^th agents express diversity constraints
    for ind1 = 1 : m
        for ind2 = ind1 + 1 : m

            %use convex optimization solver to compute the optimal allocation without diversity constraint
            cvx_begin
                %allocation; x(i, j) denotes the allocation of the ith item to the jth agent
                variable x(n, m);
                %maximize(sum(((x .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
                %maximize(sum(((x .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
                %maximize(sum((x .* V)' * onesn)); %implements social welfare
                %maximize(sum(log((x .* V)' * onesn))); %implements nash welfare
                minimize(sum(pow_p((x .* V)' * onesn, -1))); %implements gamma-fairness for gamma = -1; approximate for MMF
                
                subject to
                    0 <= x; %constraint: allocation is nonnegative
                    x <= 1; %constraint: each individual allocation is no greater than 1
                    x * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1
                    (x .* V)' * onesn <= budget %budget constraint
            cvx_end

            %use convex optimization solver to compute the optimal allocation with diversity constraint
            cvx_begin
                variable y(n, m);
                %maximize(sum(((y .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
                %maximize(sum(((y .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
                %maximize(sum((y .* V)' * onesn)); %implements social welfare
                %maximize(sum(log((y .* V)' * onesn))); %implements nash welfare
                minimize(sum(pow_p((y .* V)' * onesn, -1))); %implements gamma-fairness for gamma = -1; approximate for MMF
                
                subject to
                    0 <= y; %constraint: allocation is nonnegative
                    y <= 1; %constraint: each individual allocation is no greater than 1
                    y * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1

                    %diversity constraint: equalize the allocation of all
                    %items for the ind1^th and ind2^th agent; if the value of an item for this agent is 0, then
                    %we will ignore this item for this agent (that is, do not 
                    %require the allocation of this item to be equal to the others)
                    V(1, ind1) * V(2, ind1) * y(1, ind1) ==  V(1, ind1) * V(2, ind1) * y(2, ind1);
                    V(1, ind1) * V(3, ind1) * y(1, ind1) ==  V(1, ind1) * V(3, ind1) * y(3, ind1);
                    V(1, ind1) * V(4, ind1) * y(1, ind1) ==  V(1, ind1) * V(4, ind1) * y(4, ind1);
                    V(1, ind1) * V(5, ind1) * y(1, ind1) ==  V(1, ind1) * V(5, ind1) * y(5, ind1);
                    V(1, ind1) * V(6, ind1) * y(1, ind1) ==  V(1, ind1) * V(6, ind1) * y(6, ind1);
                    V(2, ind1) * V(3, ind1) * y(2, ind1) ==  V(2, ind1) * V(3, ind1) * y(3, ind1);
                    V(2, ind1) * V(4, ind1) * y(2, ind1) ==  V(2, ind1) * V(4, ind1) * y(4, ind1);
                    V(2, ind1) * V(5, ind1) * y(2, ind1) ==  V(2, ind1) * V(5, ind1) * y(5, ind1);
                    V(2, ind1) * V(6, ind1) * y(2, ind1) ==  V(2, ind1) * V(6, ind1) * y(6, ind1);
                    V(3, ind1) * V(4, ind1) * y(3, ind1) ==  V(3, ind1) * V(4, ind1) * y(4, ind1);
                    V(3, ind1) * V(5, ind1) * y(3, ind1) ==  V(3, ind1) * V(5, ind1) * y(5, ind1);
                    V(3, ind1) * V(6, ind1) * y(3, ind1) ==  V(3, ind1) * V(6, ind1) * y(6, ind1);
                    V(4, ind1) * V(5, ind1) * y(4, ind1) ==  V(4, ind1) * V(5, ind1) * y(5, ind1);
                    V(4, ind1) * V(6, ind1) * y(4, ind1) ==  V(4, ind1) * V(6, ind1) * y(6, ind1);
                    V(5, ind1) * V(6, ind1) * y(5, ind1) ==  V(5, ind1) * V(6, ind1) * y(6, ind1);
                    V(1, ind2) * V(2, ind2) * y(1, ind2) ==  V(1, ind2) * V(2, ind2) * y(2, ind2);
                    V(1, ind2) * V(3, ind2) * y(1, ind2) ==  V(1, ind2) * V(3, ind2) * y(3, ind2);
                    V(1, ind2) * V(4, ind2) * y(1, ind2) ==  V(1, ind2) * V(4, ind2) * y(4, ind2);
                    V(1, ind2) * V(5, ind2) * y(1, ind2) ==  V(1, ind2) * V(5, ind2) * y(5, ind2);
                    V(1, ind2) * V(6, ind2) * y(1, ind2) ==  V(1, ind2) * V(6, ind2) * y(6, ind2);
                    V(2, ind2) * V(3, ind2) * y(2, ind2) ==  V(2, ind2) * V(3, ind2) * y(3, ind2);
                    V(2, ind2) * V(4, ind2) * y(2, ind2) ==  V(2, ind2) * V(4, ind2) * y(4, ind2);
                    V(2, ind2) * V(5, ind2) * y(2, ind2) ==  V(2, ind2) * V(5, ind2) * y(5, ind2);
                    V(2, ind2) * V(6, ind2) * y(2, ind2) ==  V(2, ind2) * V(6, ind2) * y(6, ind2);
                    V(3, ind2) * V(4, ind2) * y(3, ind2) ==  V(3, ind2) * V(4, ind2) * y(4, ind2);
                    V(3, ind2) * V(5, ind2) * y(3, ind2) ==  V(3, ind2) * V(5, ind2) * y(5, ind2);
                    V(3, ind2) * V(6, ind2) * y(3, ind2) ==  V(3, ind2) * V(6, ind2) * y(6, ind2);
                    V(4, ind2) * V(5, ind2) * y(4, ind2) ==  V(4, ind2) * V(5, ind2) * y(5, ind2);
                    V(4, ind2) * V(6, ind2) * y(4, ind2) ==  V(4, ind2) * V(6, ind2) * y(6, ind2);
                    V(5, ind2) * V(6, ind2) * y(5, ind2) ==  V(5, ind2) * V(6, ind2) * y(6, ind2);

                    (y .* V)' * onesn <= budget %budget constraint
            cvx_end

            XV = x .* V; %ultimate valuation without diversity constraint
            YV = y .* V; %ultimate valuation with diversity constraint

            %compute the maximum q such that it satisfies q-NNE
            q = 1;
            for j = 1 : m
                orig = sum(XV( : ,j));
                after = sum(YV( : ,j));
                %we do not consider agents who get little valuation to begin with
                if j ~= ind1 && j ~= ind2 && orig > 0.1 * budget(j, 1)
                    q = min(q, after / orig);
                end 
            end

            res = min(res, q);
        end
    end
    
    res_all(seed, 1) = res;
end